<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * Class UserApplicationAttributeController
 * @package Sso\DemoBundle\Controller
 */
class UserApplicationAttributeController extends BaseController
{

    const API_VERSION = "apiVersion";

    /**
     * @Route("/", name="_sso_demo_userapplicationattribute_add")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add(static::API_VERSION,
                'choice', [
                    'choices' => [
                        1 => 'Version 1',
                        2 => 'Version 2',
                    ],
                ])
            ->add('Guid', 'text')
            ->add('Email', 'text')
            ->add('Username', 'text')
            ->add('Identifier', 'text')
            ->add('Applicationname', 'text')
            ->add('Attributename', 'text')
            ->add('Attributetype', 'text')
            ->add('Attributevalue', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplicationAttribute', 'Add');
    }

    /**
     * @Route("/", name="_sso_demo_userapplicationattribute_delete")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add(static::API_VERSION,
                'choice', [
                    'choices' => [
                        1 => 'Version 1',
                    ],
                ])
            ->add('Guid', 'text')
            ->add('Email', 'text')
            ->add('Username', 'text')
            ->add('Identifier', 'text')
            ->add('Applicationname', 'text')
            ->add('Attributename', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplicationAttribute', 'Delete');
    }

    /**
     * @Route("/", name="_sso_demo_userapplicationattribute_show")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add(static::API_VERSION,
                'choice', array(
                    'choices' => array(
                        1 => 'Version 1',
                        2 => 'Version 2',
                    ),
                ))
            ->add('Guid', 'text')
            ->add('Email', 'text')
            ->add('Username', 'text')
            ->add('Identifier', 'text')
            ->add('Applicationname', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplicationAttribute', 'Show');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationAttributeAdd($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplicationAttribute>
                            <Add>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                    <ApplicationType>
                                        <Name>" . $params['Applicationname'] . "</Name>
                                    </ApplicationType>
                                </Key>
                                <Value>
                                    <AttributeType>
                                        <Name>" . $params['Attributename'] . "</Name>
                                        <Type>" . $params['Attributetype'] . "</Type>
                                        <Value>" . $params['Attributevalue'] . "</Value>
                                    </AttributeType>
                                </Value>
                            </Add>
                        </UserApplicationAttribute>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationAttributeShow($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplicationAttribute>
                            <Show>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                    <ApplicationType>
                                        <Name>" . $params['Applicationname'] . "</Name>
                                    </ApplicationType>
                                </Key>
                            </Show>
                        </UserApplicationAttribute>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationAttributeDelete($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplicationAttribute>
                            <Delete>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                    <ApplicationType>
                                        <Name>" . $params['Applicationname'] . "</Name>
                                    </ApplicationType>
                                    <AttributeType>
                                        <Name>" . $params['Attributename'] . "</Name>
                                    </AttributeType>
                                </Key>
                            </Delete>
                        </UserApplicationAttribute>
                    </SsoRequest>";
    }
}
