<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * Class UserGroupController
 * @package Sso\DemoBundle\Controller
 */
class UserGroupController extends BaseController
{
    /**
     * @Route()
     * @Template()
     * @param Request $request
     * @return array
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion',
                'choice', [
                    'choices' => [
                        2 => 'Version 2',
                    ],
                ])
            ->add('Name', 'text')
            ->add('Description', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserGroup', 'Add');
    }

    /**
     * @Route()
     * @Template(template="@SsoDemo/UserGroup/search.html.twig")
     * @param Request $request
     * @return array
     */
    public function searchAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion',
                'choice', [
                    'choices' => [
                        2 => 'Version 2',
                    ],
                ])
            ->add('limit', TextType::class)
            ->add('offset', TextType::class)
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserGroup', 'Search');
    }

    /**
     * @Route("/", name="_sso_demo_user_group_delete")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion',
                'choice', [
                    'choices' => [
                        2 => 'Version 2',
                    ],
                ])
            ->add('Name', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserGroup', 'Delete');
    }

    /**
     * @Route("/", name="_sso_demo_user_group_update")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function updateAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice',
                [
                    'choices' =>
                        [
                            2 => 'Version 2',
                        ]
                ])
            ->add('UserGroupKeyDataName', 'text')
            ->add('Name', 'text')
            ->add('Description', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserGroup', 'Update');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserGroupAdd($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserGroup>
                            <Add>
                                <Value>
                                    <UserGroupType>
                                        <Name>" . $params['Name'] . "</Name>
                                        <Description>" . $params['Description'] . "</Description>
                                    </UserGroupType>
                                </Value>
                            </Add>
                        </UserGroup>
                    </SsoRequest>";
    }

    /**
     * @var array $params
     * @return string
     */
    protected function xmlUserGroupSearch($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserGroup>
                            <Search>
                                " . (0 < strlen($params['limit']) ? "<Limit>" . $params['limit'] . "</Limit>" : "") . "
                                " . (0 < strlen($params['offset']) ? "<Offset>" . $params['offset'] . "</Offset>" : "") . "
                            </Search>
                        </UserGroup>
                    </SsoRequest>";
    }

    /**
     * @var array $params
     * @return string
     */
    protected function xmlUserGroupDelete($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserGroup>
                            <Delete>
                                <Key>
                                    <UserGroupType>
                                        <Name>" . $params['Name'] . "</Name>
                                    </UserGroupType>
                                </Key>
                            </Delete>
                        </UserGroup>
                    </SsoRequest>";
    }

    /**
     * @var array $params
     * @return string
     */
    protected function xmlUserGroupUpdate($params = array())
    {
        $updateValues = array();
        foreach (array(
                     'Name',
                     'Description'
                 ) as $field) {
            if (strlen($params[$field])) {
                $updateValues[] = "<" . $field . ">" . $params[$field] . "</" . $field . ">";
            }
        }

        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserGroup>
                            <Update>
                                <Key>
                                    <UserGroupType>
                                        <Name>" . $params['UserGroupKeyDataName'] . "</Name>
                                    </UserGroupType>
                                </Key>
                                <Value>
                                    <UserGroupType>" . implode("\n", $updateValues) . "</UserGroupType>
                                </Value>
                            </Update>
                        </UserGroup>
                    </SsoRequest>";
    }
}
