<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sso\DemoBundle\Form\UserSearch\Advanced as UserSearchAdvancedForm;

/**
 * Class UserSearchController
 * @package Sso\DemoBundle\Controller
 */
class UserSearchController extends BaseController
{
    /**
     * @Route("/", name="_sso_demo_usersearch_advanced")
     * @Template("SsoDemoBundle:UserSearch:advanced.html.twig")
     * @param Request $request
     * @return array
     */
    public function advancedAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [2 => 'Version 2', 3 => 'Version 3']])
            ->add('Offset', 'integer')
            ->add('Limit', 'integer')
            ->add('OrderBy', 'choice', [
                    'choices' => [
                        '' => '',
                        'NotValid' => 'NotValid',
                        'Username' => 'Username',
                        'Email' => 'Email',
                        'Firstname' => 'Firstname',
                        'Lastname' => 'Lastname',
                        'Active' => 'Active',
                        'Deleted' => 'Deleted',
                        'CreatedAt' => 'CreatedAt',
                        'UpdatedAt' => 'UpdatedAt',
                        'LastLoginAt' => 'LastLoginAt',
                        'MfaEnabled' => 'MfaEnabled'
                    ]
                ]
            )
            ->add('OrderDir', 'choice',
                ['choices' => ['' => '', 'NotValid' => 'NotValid', 'ASC' => 'ASC', 'DESC' => 'DESC']])
            ->add('FullResponse', 'choice', ['choices' => [0 => 0, 1 => 1]])
            ->add("UserType", 'collection', [
                'entry_type' => new UserSearchAdvancedForm\UserType(),
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'by_reference' => false
            ])
            ->add("AddFilters", 'textarea')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserSearch', 'Advanced', false, false);
    }

    /**
     * @Route("/", name="_sso_demo_usersearch_find_by_application")
     * @Template("SsoDemoBundle:UserSearch:findbyapplication.html.twig")
     * @param Request $request
     * @return array
     */
    public function findByApplicationAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add('ApplicationName', 'text')
            ->add('ApplicationActive', 'text')
            ->add('ModifiedAfter', 'datetime', [
                    'required' => false,
                    'date_format' => 'yyyy-MM-dd  HH:mm',
                    'empty_value' => null,
                ]
            )
            ->add('UseDateInRequest', 'choice', ['choices' => ['yes' => 'yes', 'no' => 'no']])
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserSearch', 'FindByApplication');
    }

    /**
     * @Route("/", name="_sso_demo_usersearch_find_by_applicationattribute")
     * @Template("SsoDemoBundle:UserSearch:findbyapplicationattribute.html.twig")
     * @param Request $request
     * @return array
     */
    public function findByApplicationAttributeAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add('ApplicationName', 'text')
            ->add('UserApplicationActive', 'text')
            ->add('AttributeName', 'text')
            ->add('AttributeValue', 'text')
            ->add('ModifiedAfter', 'datetime', [
                'required' => false,
                'date_format' => 'yyyy-MM-dd  HH:mm',
                'empty_value' => null,
            ])
            ->add('UseDateInRequest', 'choice', ['choices' => ['yes' => 'yes', 'no' => 'no']])
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserSearch', 'FindByApplicationAttribute');
    }

    /**
     * @Route("/", name="_sso_demo_usersearch_find_by_applicationrole")
     * @Template("SsoDemoBundle:UserSearch:findbyapplicationrole.html.twig")
     * @param Request $request
     * @return array
     */
    public function findByApplicationRoleAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add('ApplicationName', 'text')
            ->add('ApplicationActive', 'text')
            ->add('RoleName', 'text')
            ->add('RoleActive', 'text')
            ->add('ModifiedAfter', 'datetime', [
                'required' => false,
                'date_format' => 'yyyy-MM-dd  HH:mm',
                'empty_value' => null,
            ])
            ->add('UseDateInRequest', 'choice', ['choices' => ['yes' => 'yes', 'no' => 'no']])
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserSearch', 'FindByApplicationRole');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserSearchAdvanced($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserSearch>
                            <Advanced>
                                " . $this->xmlAdvancedUserSearchHelper($params) . "
                            </Advanced>
                        </UserSearch>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserSearchFindByApplication($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserSearch>
                            <FindByApplication>
                                <Key>
                                    " . (($params['ModifiedAfter'] && $params['UseDateInRequest'] == 'yes') ? "<UserType><ModifiedAfter>" . $params['ModifiedAfter']->format(\DateTime::W3C) . "</ModifiedAfter></UserType>" : "") . "
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                        " . (strlen($params['ApplicationActive']) ? "<Active>" . $params['ApplicationActive'] . "</Active>" : "") . "
                                    </ApplicationType>
                                </Key>
                            </FindByApplication>
                        </UserSearch>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserSearchFindByApplicationAttribute($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserSearch>
                            <FindByApplicationAttribute>
                                <Key>
                                    " . (($params['ModifiedAfter'] && $params['UseDateInRequest'] == 'yes') ? "<UserType><ModifiedAfter>" . $params['ModifiedAfter']->format(\DateTime::W3C) . "</ModifiedAfter></UserType>" : "") . "
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                        " . (strlen($params['UserApplicationActive']) ? "<Active>" . $params['UserApplicationActive'] . "</Active>" : "") . "
                                    </ApplicationType>
                                    <AttributeType>
                                        <Name>" . $params['AttributeName'] . "</Name>
                                        <Value>" . $params['AttributeValue'] . "</Value>
                                    </AttributeType>
                                </Key>
                            </FindByApplicationAttribute>
                        </UserSearch>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserSearchFindByApplicationRole($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserSearch>
                            <FindByApplicationRole>
                                <Key>
                                    " . (($params['ModifiedAfter'] && $params['UseDateInRequest'] == 'yes') ? "<UserType><ModifiedAfter>" . $params['ModifiedAfter']->format(\DateTime::W3C) . "</ModifiedAfter></UserType>" : "") . "
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                         " . (strlen($params['ApplicationActive']) ? "<Active>" . $params['ApplicationActive'] . "</Active>" : "") . "
                                    </ApplicationType>
                                    <RoleType>
                                        <Name>" . $params['RoleName'] . "</Name>
                                        " . (strlen($params['RoleActive']) ? "<Active>" . $params['RoleActive'] . "</Active>" : "") . "
                                    </RoleType>
                                </Key>
                            </FindByApplicationRole>
                        </UserSearch>
                    </SsoRequest>";
    }
}
