<?php

/**
 * Class Filter
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\DemoBundle\Form\UserSearch\Advanced;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

/**
 * Class AttributeGroupUpdateType
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\DemoBundle\Form
 */
class ApplicationType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add(
            'Servus',
            'choice',
            [
                'choices' => ['TEST' => 'TEST', 'LIKE' => 'LIKE', 'EQUAL' => 'EQUAL', 'REGEX' => 'REGEX'],
            ]
        )
            ->add(
                'Operator',
                'choice',
                [
                    'choices' => ['TEST' => 'TEST', 'AND' => 'AND', 'OR' => 'OR'],
                ]
            );
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_webservices_demobundle_user_search_filter';
    }
}
