<?php

/**
 * Class Filter
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\DemoBundle\Form\UserSearch\Advanced;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

/**
 * Class AttributeGroupUpdateType
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\DemoBundle\Form
 */
class UserType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('Operator', 'choice', ['choices' => $this->operatorChoices()])
            ->add('Strategy', 'choice', ['choices' => $this->strategyChoices()])
            ->add('UserTypeGuid', 'text', ['required' => false])
            ->add('UserTypeGuid', 'text', ['required' => false])
            ->add('UserTypeEmail', 'text', ['required' => false])
            ->add('UserTypeUsername', 'text', ['required' => false])
            ->add('UserTypeFirstname', 'text', ['required' => false])
            ->add('UserTypeLastname', 'text', ['required' => false])
            ->add('UserTypeActive', 'integer', ['required' => false])
            ->add('UserTypeDeleted', 'integer', ['required' => false])
            ->add('UserTypeMfaEnabled', 'integer', ['required' => false])
            ->add('UserTypeCreatedAt', 'datetime', ['required' => false])
            ->add('UserTypeUpdatedAt', 'datetime', ['required' => false]);

    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_webservices_demobundle_user_search_filter';
    }

    /**
     * @return array
     */
    private function strategyChoices()
    {
        return [
            '' => 'NotSet',
            'INVALID' => 'INVALID',
            'EQ' => 'EQ',
            'NOT EQ' => 'NOT EQ',
            'GT' => 'GT',
            'GTE' => 'GTE',
            'LT' => 'LT',
            'LTE' => 'LTE',
            'LIKE' => 'LIKE',
            'NOT LIKE' => 'NOT LIKE',
            'REGEX' => 'REGEX',
            'IN' => 'IN'
        ];
    }

    /**
     * @return array
     */
    private function operatorChoices()
    {
        return ['' => 'NotSet', 'INVALID' => 'INVALID', 'AND' => 'AND', 'OR' => 'OR', 'AND NOT' => 'AND NOT',];
    }
}
