<?php

namespace Sso\DemoBundle\Tests\Controller;

use Sso\DemoBundle\Tests\FunctionalTestCase;

class IndexControllerTest extends FunctionalTestCase
{
    public function testIndex()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Available Webservice Requests")')->count() > 0);
    }

    public function testXml()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/xml');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Send Xml")')->count() > 0);
    }

}
