<?php

namespace Sso\DemoBundle\Tests\Controller;

use Sso\DemoBundle\Tests\FunctionalTestCase;

class UserApplicationAttributeControllerTest extends FunctionalTestCase
{
    public function testSet()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/application/attribute/add');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("UserApplicationAttribute - Add")')->count() > 0);
    }

    public function testDelete()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/application/attribute/delete');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("UserApplicationAttribute - Delete")')->count() > 0);
    }

    public function testShow()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/application/attribute/show');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("UserApplicationAttribute - Show")')->count() > 0);
    }

}
