<?php

namespace Sso\DemoBundle\Tests\Controller;

use Sso\DemoBundle\Tests\FunctionalTestCase;

class UserApplicationControllerTest extends FunctionalTestCase
{
    public function testAdd()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/application/add');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("UserApplication - Add")')->count() > 0);
    }

    public function testDelete()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/application/delete');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("UserApplication - Delete")')->count() > 0);
    }

    public function testShow()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/application/show');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("UserApplication - Show")')->count() > 0);
    }

}
