<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2018 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Configuration;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Configuration
 * @package Sso\RestBundle\Api\Configuration
 */
class Configuration
{
    /**
     * @var bool
     */
    private $userBlockingEnabled = false;

    /**
     * @var int
     */
    private $maxLoginFails = 0;

    /**
     * @var int
     */
    private $clearTimeSec = 0;

    /**
     * Configuration constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        if ($container->hasParameter('sso_rest')) {
            $restParams = $container->getParameter('sso_rest');
            if (isset($restParams['blocking_enabled'])) {
                $this->userBlockingEnabled = $restParams['blocking_enabled'];
                $this->maxLoginFails = $restParams['max_login_fails'];
                $this->clearTimeSec = $restParams['clear_time_sec'];
            }
        }
    }

    /**
     * @return bool
     */
    public function isUserBlockingEnabled()
    {
        return $this->userBlockingEnabled;
    }

    /**
     * @return int
     */
    public function getMaxLoginFails()
    {
        return $this->maxLoginFails;
    }

    /**
     * @return int
     */
    public function getClearTimeSec()
    {
        return $this->clearTimeSec;
    }
}
