<?php

/**
 * User: sb
 * Date: 28.12.2015
 * Time: 10:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH
 * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\RestBundle\Api;

use Symfony\Component\HttpKernel\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Sso\RestBundle\Worker\Manager as WorkerManager;
use LifeStyle\Tools\RestErrorBundle\Api\Manager as ErrorManager;
use Sso\RestBundle\Model\Factory as ModelManager;
use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Class Manager
 * @package Sso\RestBundle\Api
 */
class Manager
{
    /**
     * @var Container
     */
    public $container;

    /**
     *
     * @var LoggerInterface
     */
    public $logger;

    /**
     * List of this factories
     *
     * @var array
     */
    protected $apiSetter;

    /**
     * Manager constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
        $this->logger = $this->container->get('logger');
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        if (!isset($this->factory['worker'])) {
            $this->factory['worker'] = new WorkerManager($this);
        }
        return $this->factory['worker'];
    }

    /**
     * @return Database\Factory
     */
    public function database()
    {
        if (!isset($this->factory['database'])) {
            $this->factory['database'] = new Database\Factory($this->container);
        }
        return $this->factory['database'];
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Manager
     */
    public function webserviceDatabase()
    {
        return $this->container->get('service_database_manager');
    }

    /**
     * @return ModelManager
     */
    public function model()
    {
        if (!isset($this->factory['model'])) {
            $this->factory['model'] = new ModelManager();
        }
        return $this->factory['model'];
    }

    /**
     * @return Validate\Factory
     */
    public function validate()
    {
        if (!isset($this->factory['validate'])) {
            $this->factory['validate'] = new Validate\Factory($this);
        }
        return $this->factory['validate'];
    }

    /**
     * @return Session
     */
    public function session()
    {
        if (!isset($this->factory['session'])) {
            $this->factory['session'] = new Session();
        }
        return $this->factory['session'];
    }

    /**
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    public function validator()
    {
        return $this->container->get('validator');
    }

    /**
     *
     * @return Container
     */
    public function getContainer()
    {
        return $this->container;
    }

    /**
     * The logger
     *
     * @return LoggerInterface
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     *
     * @return ErrorManager
     */
    public function errorManager()
    {
        return $this->container->get('rest_error_api_manager');
    }

    /**
     * JMS Serializer
     *
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }

    /**
     *
     * @return Helper\Factory
     */
    public function helper()
    {
        if (!isset($this->setter['helper'])) {
            $this->setter['helper'] = new Helper\Factory();
        }
        return $this->setter['helper'];
    }

    /**
     * @return Configuration\Configuration
     */
    public function configuration(){
        if (!isset($this->factory['configuration'])) {
            $this->factory['configuration'] = new Configuration\Configuration($this->container);
        }
        return $this->factory['configuration'];
    }
}
