<?php

/**
 * @author buchhofer
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Controller;

use FOS\RestBundle\Controller\Annotations\RequestParam;
use FOS\RestBundle\Controller\Annotations\QueryParam;
use FOS\RestBundle\View\View;
use FOS\RestBundle\Request\ParamFetcher;
use JMS\SecurityExtraBundle\Annotation\Secure;
use Symfony\Component\Validator\ConstraintViolationList;
use Nelmio\ApiDocBundle\Annotation\ApiDoc;
use LifeStyle\Tools\RestAuthBundle\Security\Authentication\Token\UidentifyToken;
use FOS\RestBundle\Controller\Annotations\NamePrefix;
use Symfony\Component\HttpFoundation\Request;
use Sso\BackendSecurityBundle\Entity\User as User;

/**
 * @NamePrefix("api_rest_")
 */
class TokenController extends AbstractController
{

    /**
     * Create a Token (x-wsse header) from your submitted data. The x-wsse header is required to authenticate, the
     * secured services.
     * <br/>
     * This service is only for testing, please **do not use this service in the production environment!**
     * **Create the x-wsse header yourself this brings more security!**
     *
     * #Request (parameters)
     *
     *      Key                 | Value               | Method
     *      ------------------- | ------------------- | --------------------------------------
     *      username            |  (string)           | POST
     *      password            |  (string)           | POST
     *      salt                |  (string)           | POST
     *
     *
     * **Request example XML**
     *
     *      POST /api/service/tokens.xml
     *
     * **Request example JSON**
     *
     *      POST /api/service/tokens.json
     *
     * ##Response Success 200 (ok)
     *
     * **Example XML Response 200 (body)**
     *
     *       <?xml version="1.0" encoding="UTF-8"?>
     *       <TokenResponse>
     *           <username><![CDATA[...]]></username>
     *           <passwordDigest><![CDATA[...]]></passwordDigest>
     *           <nonce><![CDATA[...]]></nonce>
     *           <created><![CDATA[2016-01-11T09:02:09+01:00]]></created>
     *           <x-wsse><![CDATA[UsernameToken Username="...", PasswordDigest="...", Nonce="...", Created="2016-01-11T09:02:09+01:00"]]></x-wsse>
     *       </TokenResponse>
     *
     * **Example JSON Response 200 (body)**
     *
     *       {
     *       "username": "...",
     *       "passwordDigest": "...",
     *       "nonce": "...",
     *       "created": "2016-01-11T09:00:49+01:00",
     *       "x-wsse": "UsernameToken Username=\"...\", PasswordDigest=\"...=\", Nonce=\"...\", Created=\"2016-01-11T09:00:49+01:00\""
     *       }
     *
     *
     * ##Response error
     *
     * **Example (header)**
     *
     *      400 Bad Request
     *
     * **Example JSON (body)**
     *
     *       {
     *       "status": 400,
     *       "message": "Bad Request",
     *       "trackId": "13562a3481",
     *       "count": 1,
     *       "errors": [
     *              {
     *              "code": 400,
     *              "message": "here is the error message",
     *              "trackId": "13562a3481",
     *              "type": "external",
     *              "exception": "not set",
     *              "debug": "not set"
     *              }
     *          ]
     *       }
     *
     *
     * **Example XML (body)**
     *
     *      <?xml version="1.0" encoding="UTF-8"?>
     *       <response>
     *          <status>400</status>
     *          <message><![CDATA[Bad Request]]></message>
     *          <trackId><![CDATA[13562a3481]]></trackId>
     *          <count>1</count>
     *          <errors>
     *              <error>
     *                  <code>400</code>
     *                  <message><![CDATA[here is the error message]></message>
     *                  <trackId><![CDATA[13562a3481]]></trackId>
     *                  <type><![CDATA[external]]></type>
     *                  <exception><![CDATA[not set]]></exception>
     *                  <debug><![CDATA[not set]]></debug>
     *              </error>
     *          </errors>
     *       </response>
     *
     *
     * @ApiDoc(
     *   resource = true,
     *   description = "unsecured: create x-wsse header",
     *   statusCodes = {
     *     200 = "Returned when successful",
     *     400 = "Returned when the form has errors"
     *   },
     *   tags={
     *         "stable" = "#FF0000"
     *     }
     * )
     *
     * @param ParamFetcher $paramFetcher Paramfetcher
     *
     * @RequestParam(name="username", nullable=false, strict=true, description="username.")
     * @RequestParam(name="password", nullable=false, strict=true, description="password.")
     * @RequestParam(name="salt", nullable=false, strict=true, description="salt.")
     *
     * @return View
     */
    public function postTokenAction(ParamFetcher $paramFetcher)
    {

        return $this->restApiM()->worker()->token()->postToken()->init($paramFetcher);
    }
}
