<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Model\Request;

/**
 * Class Factory
 * @package Sso\RestBundle\Model\Request
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Token\Factory
     */
    public function token()
    {
        if (!isset($this->facSetter['token'])) {
            $this->facSetter['token'] = new Token\Factory();
        }
        return $this->facSetter['token'];
    }

    /**
     * @return Idp\Factory
     */
    public function idp()
    {
        if (!isset($this->facSetter['idp'])) {
            $this->facSetter['idp'] = new Idp\Factory();
        }
        return $this->facSetter['idp'];
    }

    /**
     * @return Mfa\Factory
     */
    public function mfa()
    {
        if (!isset($this->facSetter['mfa'])) {
            $this->facSetter['mfa'] = new Mfa\Factory();
        }
        return $this->facSetter['mfa'];
    }

    /**
     * @return User\Factory
     */
    public function user()
    {
        if (!isset($this->facSetter['user'])) {
            $this->facSetter['user'] = new User\Factory();
        }
        return $this->facSetter['user'];
    }
}
