<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Model\Response\Token\PostToken;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 * @package Sso\RestBundle\Model\Response\Token\PostToken
 *
 * @Serializer\XmlRoot("TokenResponse")
 */
class Response
{
    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("passwordDigest")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $passwordDigest;

    /**
     * @Serializer\SerializedName("nonce")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $nonce;

    /**
     * @Serializer\SerializedName("created")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $created;

    /**
     * @Serializer\SerializedName("x-wsse")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $fullHeader;

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return Response
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getPasswordDigest()
    {
        return $this->passwordDigest;
    }

    /**
     * @param string $passwordDigest
     * @return Response
     */
    public function setPasswordDigest($passwordDigest)
    {
        $this->passwordDigest = $passwordDigest;

        return $this;
    }

    /**
     * @return string
     */
    public function getNonce()
    {
        return $this->nonce;
    }

    /**
     * @param string $nonce
     * @return Response
     */
    public function setNonce($nonce)
    {
        $this->nonce = $nonce;

        return $this;
    }

    /**
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param string $created
     * @return Response
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * @return string
     */
    public function getFullHeader()
    {
        return $this->fullHeader;
    }

    /**
     * @param string $fullHeader
     */
    public function setFullHeader($fullHeader)
    {
        $this->fullHeader = $fullHeader;
    }
}
