<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Model\Response\User\PostApplicationAttributes;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 * @package Sso\RestBundle\Model\Response\Idp\PostLoginSuccess
 */
class ApplicationType
{
    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("array<Sso\RestBundle\Model\Response\User\PostApplicationAttributes\Attribute>")
     * @Serializer\XmlList(inline = false, entry = "attribute")
     *
     * @var Attribute[]
     */
    private $attributes;

    /**
     * @Serializer\SerializedName("roles")
     * @Serializer\Type("array<Sso\RestBundle\Model\Response\User\PostApplicationAttributes\Role>")
     * @Serializer\XmlList(inline = false, entry = "role")
     * @var Role[]
     */
    private $roles;

    /**
     * ApplicationType constructor.
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = (string)$name;
        $this->attributes = array();
        $this->roles = array();
    }

    /**
     * @param Attribute $attribute
     * @return ApplicationType
     */
    public function addAttribute(Attribute $attribute)
    {
        $this->attributes[] = $attribute;
        return $this;
    }

    /**
     * @param Role $role
     * @return ApplicationType
     */
    public function addRole(Role $role)
    {
        $this->roles[] = $role;
        return $this;
    }
}
