<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Model\Response\User\PostApplicationAttributes;

/**
 * Class Factory
 * @package Sso\RestBundle\Model\Response\User\PostApplicationAttributes
 */
class Factory
{
    /**
     * @return Response
     */
    public function response()
    {
        return new Response();
    }

    /**
     * @param string $name
     * @param string $value
     * @param string $type
     * @return Attribute
     */
    public function attribute($name, $value, $type)
    {
        return new Attribute($name, $value, $type);
    }

    /**
     * @param string $name
     * @return Role
     */
    public function role($name)
    {
        return new Role($name);
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function applicationType($name)
    {
        return new ApplicationType($name);
    }
}
