<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Model\Response\User\PostApplicationAttributes;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;

/**
 * Class Response
 * @package Sso\RestBundle\Model\Response\Idp\PostLoginSuccess
 *
 * @Serializer\XmlRoot("response")
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("durationSeconds")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $durationSeconds;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("applications")
     * @Serializer\Type("array<Sso\RestBundle\Model\Response\User\PostApplicationAttributes\ApplicationType>")
     *
     * @var ApplicationType[]|ArrayCollection
     */
    private $applications;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->trackId = ApiException::getTrackId();
        $this->applications = new ArrayCollection();
    }

    /**
     * @param int $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @param string $message
     * @return Response
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @param string $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @param string $durationSeconds
     * @return Response
     */
    public function setDurationSeconds($durationSeconds)
    {
        $this->durationSeconds = $durationSeconds;

        return $this;
    }

    /**
     * @param string $username
     * @return Response
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @param ApplicationType $application
     * @return Response
     */
    public function addApplication(ApplicationType $application)
    {
        $this->applications[] = $application;

        return $this;
    }
}
