<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2018 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace  Sso\RestBundle\Tests\DependencyInjection;

use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Sso\RestBundle\DependencyInjection\SsoRestExtension;

/**
 * Class SsoRestExtensionTest
 * @package Sso\RestBundle\Tests\DependencyInjection
 */
class SsoRestExtensionTest extends TestCase
{
    /**
     * @return void
     */
    public function testAppExtension()
    {
        $ssoRestExt = new SsoRestExtension();

        $containerBuilder = $this->getMockBuilder(ContainerBuilder::class)
            ->disableOriginalConstructor()
            ->setMethods(['setDefinition','setParameter'])
            ->getMock();

        $containerBuilder->expects($this->exactly(1))
            ->method('setDefinition');

        $containerBuilder->expects($this->exactly(1))
            ->method('setParameter');

        $ssoRestExt->load($this->getConfigs(), $containerBuilder);
    }

    /**
     * @return array
     */
    private function getConfigs()
    {
        return [
            'sso_rest' => [
                'blocking_enabled' => true,
                'max_login_fails' => 3,
                'clear_time_sec' => 30,
                ]
        ];
    }
}
