<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2018 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace  Sso\RestBundle\Tests\Model\Request\Idp\PostLogin;

use PHPUnit\Framework\TestCase;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Sso\RestBundle\Model\Request\Idp\PostLogin\Request as RequestModel;

/**
 * Class RequestTest
 * @package Sso\RestBundle\Tests\Model\Request\Idp\PostLogin
 */
class RequestTest extends TestCase
{
    /**
     * @return void
     */
    public function testRequestModelSerializer()
    {
        /** @var Serializer $serializer */
        $serializer = SerializerBuilder::create()->build();

        $responseModel = new RequestModel();
        $responseModel->setUserIdentifier('admin');
        $responseModel->setPassword('hans12345');

        $responseJson = $serializer->serialize($responseModel, 'json');
        $expectedJson = '{
                          "userIdentifier": "admin",
                          "password": "hans12345"
                         }';

        $this->assertJsonStringEqualsJsonString($expectedJson, $responseJson);
    }

    /**
     * @return void
     */
    public function testResponseModelGetter()
    {
        $responseModel = new RequestModel();
        $responseModel->setUserIdentifier('admin');
        $responseModel->setPassword('hans12345');

        $this->assertEquals('admin', $responseModel->getUserIdentifier());
        $this->assertEquals('hans12345', $responseModel->getPassword());
    }
}
