<?php

/**
 *
 * @class Factory
 * @author buchhofer
 *
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\RestBundle\Worker\Idp;

use Sso\RestBundle\Api\Manager as RestApiManager;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\Idp
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var RestApiManager
     */
    protected $restApiM;

    /**
     *
     * @param RestApiManager $restApiM
     */
    public function __construct(RestApiManager $restApiM)
    {
        $this->restApiM = $restApiM;
    }

    /**
     * @return PostLogin\Handler
     */
    public function postLogin()
    {
        if (!isset($this->facSetter['postLogin'])) {
            $this->facSetter['postLogin'] = new PostLogin\Handler($this->restApiM);
        }

        return $this->facSetter['postLogin'];
    }

    /**
     * @return PostLoginSuccess\Handler
     */
    public function postLoginSuccess()
    {
        if (!isset($this->facSetter['postLoginSuccess'])) {
            $this->facSetter['postLoginSuccess'] = new PostLoginSuccess\Handler($this->restApiM);
        }

        return $this->facSetter['postLoginSuccess'];
    }

    /**
     *
     * @return PostLoginFailed\Handler
     */
    public function postLoginFailed()
    {
        if (!isset($this->facSetter['postLoginFailed'])) {
            $this->facSetter['postLoginFailed'] = new PostLoginFailed\Handler($this->restApiM);
        }

        return $this->facSetter['postLoginFailed'];
    }
}
