<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker;

use Sso\RestBundle\Api\Manager as RestApiManager;

/**
 * Class Manager
 * @package Sso\RestBundle\Worker
 */
class Manager
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var RestApiManager
     */
    protected $restApiM;

    /**
     * @param RestApiManager $restApiM
     */
    public function __construct(RestApiManager $restApiM)
    {
        $this->restApiM = $restApiM;
    }

    /**
     * @return Token\Factory
     */
    public function token()
    {
        if (!isset($this->facSetter['token'])) {
            $this->facSetter['token'] = new Token\Factory($this->restApiM);
        }

        return $this->facSetter['token'];
    }

    /**
     * @return Idp\Factory
     */
    public function idp()
    {
        if (!isset($this->facSetter['idp'])) {
            $this->facSetter['idp'] = new Idp\Factory($this->restApiM);
        }

        return $this->facSetter['idp'];
    }

    /**
     * @return Mfa\Factory
     */
    public function mfa()
    {
        if (!isset($this->facSetter['mfa'])) {
            $this->facSetter['mfa'] = new Mfa\Factory($this->restApiM);
        }

        return $this->facSetter['mfa'];
    }

    /**
     * @return User\Factory
     */
    public function user()
    {
        if (!isset($this->facSetter['user'])) {
            $this->facSetter['user'] = new User\Factory($this->restApiM);
        }

        return $this->facSetter['user'];
    }
}
