<?php

/**
 *
 * @class Factory
 * @author buchhofer
 *
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\RestBundle\Worker\Mfa;

use Sso\RestBundle\Api\Manager as RestApiManager;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\Mfa
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var RestApiManager
     */
    protected $restApiM;

    /**
     * @param RestApiManager $restApiM
     */
    public function __construct(RestApiManager $restApiM)
    {
        $this->restApiM = $restApiM;
    }

    /**
     * @return PostMfaValidate\Handler
     */
    public function postMfaValidate()
    {
        if (!isset($this->facSetter['postMfaValidate'])) {
            $this->facSetter['postMfaValidate'] = new PostMfaValidate\Handler($this->restApiM);
        }

        return $this->facSetter['postMfaValidate'];
    }

    /**
     * @return PostMfaAddUser\Handler
     */
    public function postMfaAddUser()
    {
        if (!isset($this->facSetter['postMfaAddUser'])) {
            $this->facSetter['postMfaAddUser'] = new PostMfaAddUser\Handler($this->restApiM);
        }

        return $this->facSetter['postMfaAddUser'];
    }
}
