<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\AWSBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class HealthCheckController
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\Tools\AWSBundle\Controller
 */
class HealthCheckController extends Controller
{
    /**
     * Send http-status-OK (200) for AWS health check
     *
     * @Route(path="/")
     */
    public function defaultAction()
    {
        return new Response('OK');
    }

    /**
     * Send http-status-OK (200) for AWS health check
     *
     * @Route(path="/status")
     */
    public function statusAction()
    {
        return new Response('OK');
    }
}
