<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\AWSBundle\Security;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestMatcherInterface;

/**
 * Class RequestMatcher
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\Tools\AWSBundle\Security
 */
class RequestMatcher implements RequestMatcherInterface
{
    /**
     * Decides whether the rule(s) implemented by the strategy matches the supplied request.
     *
     * @param Request $request
     * @return bool true if the request matches, false otherwise
     */
    public function matches(Request $request)
    {
        return $this->validatePath($request) && $this->validateMethod($request) && $this->validateUserAgent($request);
    }

    /**
     * @param Request $request
     * @return bool
     */
    private function validatePath(Request $request)
    {
        return in_array($request->getPathInfo(), ['/', '/status']);
    }

    /**
     * @param Request $request
     * @return bool
     */
    private function validateMethod(Request $request)
    {
        return in_array($request->getMethod(), ['GET', 'HEAD']);
    }
    /**
     * @param Request $request
     * @return bool
     */
    private function validateUserAgent(Request $request)
    {
        return
            false !== ($userAgent = $request->headers->get('User-Agent', false)) &&
            0 === stripos($userAgent, 'ELB-HealthChecker');
    }
}
