<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Api;

/**
 * Interface ControllerInterface
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\Tools\UserIdentifierBundle\Api
 */
interface ControllerInterface
{
    /**
     * @param string $username
     * @param string $password
     * @return bool|string UserIdentifier on success, false otherwise
     */
    public function userIdentifierGet($username, $password);

    /**
     * @param string $username
     * @param string $userIdentifier
     * @return boolean
     */
    public function userIdentifierValidate($username, $userIdentifier);
}