<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Request;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps UserIdentifier
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class UserIdentifier
{
    /**
     * @Serializer\Exclude()
     * @var Node\Factory
     */
    private $nodeFactory;

    /**
     * @Serializer\SerializedName("Get")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\UserIdentifier\Get")
     * @var UserIdentifier\Get
     */
    private $getAction;

    /**
     * @Serializer\SerializedName("Validate")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\UserIdentifier\Validate")
     * @var UserIdentifier\Validate
     */
    private $validateAction;

    /**
     * @param Node\Factory $nodeFactory
     */
    public function __construct(Node\Factory $nodeFactory)
    {
        $this->nodeFactory = $nodeFactory;
    }

    /**
     * @return UserIdentifier\Get
     */
    public function get()
    {
        return null !== $this->getAction ? $this->getAction : ($this->getAction = $this->nodeFactory->userIdentifierGet());
    }

    /**
     * @return UserIdentifier\Validate
     */
    public function validate()
    {
        return null !== $this->validateAction ? $this->validateAction : ($this->validateAction = $this->nodeFactory->userIdentifierValidate());
    }
}
