<?php

/**
 * Steps Response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps Response
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $Trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("string")
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Response\UserIdentifier")
     * @var Response\UserIdentifier
     */
    private $userIdentifier;

    /**
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     *
     * @return string
     */
    public function getTrackId()
    {
        return $this->Trackid;
    }

    /**
     *
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     *
     * @return Response\UserIdentifier
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }
}
