<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierTestBundle\DependencyInjection\Compiler;

use Sso\Tools\UserIdentifierTestBundle\Exception\CompilerPassException;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class UserIdentifierPass
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\Tools\UserIdentifierTestBundle\DependencyInjection\Compiler
 */
class UserIdentifierPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     * @throws CompilerPassException
     */
    public function process(ContainerBuilder $container)
    {
        if ('test' !== $container->getParameter('kernel.environment')) {
            throw new CompilerPassException('This bundle is for testing only. It should never be loaded in other environments than test!');
        }

        if (!$container->hasDefinition('sso_tools_user_identifier.api_controller')) {
            throw new CompilerPassException('Unable to find service sso_tools_user_identifier.api_controller! Please check order of bundles in AppKernel.');
        }

        $testDefinition = $container->getDefinition('sso_tools_user_identifier_test.api.controller');

        // Overwrite with test controller
        $definition = $container->getDefinition('sso_tools_user_identifier.api_controller');
        $definition->setClass($testDefinition->getClass());
        $definition->setArguments($testDefinition->getArguments());
    }
}
