<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api;

use Sso\WebserviceBundle\Api\PasswordPolicy\History\Service as HistoryService;
use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use JMS\Serializer\SerializerInterface;
use LifeStyle\Tools\MfaBundle\MfaCreator;
use Sso\WebserviceBundle\PasswordCrypt\PasswordCryptRepositoryInterface;
use Sso\WebserviceBundle\Security\Authorisation\UserAuthorization;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Interface ManagerInterface
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Api
 */
interface ApiManagerInterface
{
    /**
     * @return SerializerInterface
     */
    public function serializer();

    /**
     * @return SerializerInterface
     */
    public function customSerializer();

    /**
     * @return ErrorHandlerInterface
     */
    public function errorHandler();

    /**
     * @return Mapper\Index
     */
    public function mapper();

    /**
     * @return ValidatorInterface
     */
    public function validator();

    /**
     * @return float
     */
    public function scriptTimeSeconds();

    /**
     * @return MfaCreator
     */
    public function mfaCreator();

    /**
     * @return \Sso\WebserviceBundle\Database\Manager
     */
    public function database();

    /**
     * @return HistoryService
     */
    public function passwordHistory();

    /**
     * @return PasswordPolicy\Policy\Service
     */
    public function passwordPolicy();

    /**
     * @return PasswordCryptRepositoryInterface
     */
    public function passwordCryptRepository(): PasswordCryptRepositoryInterface;

    /**
     * @return UserAuthorization
     */
    public function userAuthorization(): UserAuthorization;
}
