<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\Exception\Type;

/**
 * Class Api
 * @package Sso\WebserviceBundle\Api\Exception\Type
 */
class Api extends Base
{
    /**
     * @var string
     */
    protected static $_controller = 'Unknown';

    /**
     * Action name
     *
     * @var string
     */
    protected static $_action = 'Unknown';

    /**
     * Track id
     *
     * @var string
     */
    protected static $_trackId = 'Unknown';

    /**
     * Set controller name
     *
     * @param string $controller
     */
    public static function setController($controller)
    {
        self::$_controller = (string)$controller;
    }

    /**
     * Get controller name
     *
     * @return string
     */
    public static function getController()
    {
        return self::$_controller;
    }

    /**
     * Set controller action name
     *
     * @param string $action
     */
    public static function setAction($action)
    {
        self::$_action = (string)$action;
    }

    /**
     * Get controller action name
     *
     * @return string
     */
    public static function getAction()
    {
        return self::$_action;
    }

    /**
     * Set track id
     *
     * @param string $trackId
     */
    public static function setTrackId($trackId)
    {
        self::$_trackId = (string)$trackId;
    }

    /**
     * Get track id
     *
     * @return string
     */
    public static function getTrackId()
    {
        return self::$_trackId;
    }
}
