<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\PasswordPolicy\User\Model;

/**
 * Class UsersPasswordPolicy
 * @package Sso\WebserviceBundle\Api\PasswordPolicy\User\Model
 */
final class UsersPasswordPolicy
{
    /**
     * @var string
     */
    private $policyId;

    /**
     * @var string
     */
    private $regEx;

    /**
     * @var integer
     */
    private $validityDuration;

    /**
     * @var integer
     */
    private $changeDelay;

    /**
     * @return string
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }

    /**
     * @param string $policyId
     * @return UsersPasswordPolicy
     */
    public function setPolicyId($policyId)
    {
        $this->policyId = $policyId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRegEx()
    {
        return $this->regEx;
    }

    /**
     * @param string $regEx
     * @return UsersPasswordPolicy
     */
    public function setRegEx($regEx)
    {
        $this->regEx = $regEx;
        return $this;
    }

    /**
     * @return int
     */
    public function getValidityDuration()
    {
        return $this->validityDuration;
    }

    /**
     * @param int $validityDuration
     * @return UsersPasswordPolicy
     */
    public function setValidityDuration($validityDuration)
    {
        $this->validityDuration = $validityDuration;
        return $this;
    }

    /**
     * @return int
     */
    public function getChangeDelay()
    {
        return $this->changeDelay;
    }

    /**
     * @param int $changeDelay
     * @return UsersPasswordPolicy
     */
    public function setChangeDelay($changeDelay)
    {
        $this->changeDelay = $changeDelay;
        return $this;
    }
}
