<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;

/**
 * Class LoadTokens2ServiceNames
 * @package Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider
 */
class LoadTokens2ServiceNames extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $serviceNames = $manager->getRepository('Sso\WebserviceBundle\Entity\ServiceProvider\Type\ServiceName')->findAll();
        $tokens = $manager->getRepository('Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token')->findAll();
        foreach ($serviceNames as $serviceName) {
            foreach ($tokens as $token) {
                $token->addServiceName($serviceName);
                $manager->persist($token);
                $serviceName->addToken($token);
                $manager->persist($serviceName);
            }
        }
        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 5;
    }
}
