<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface as Validator;

/**
 * Class Base
 * @package Sso\WebserviceBundle\Database
 */
abstract class Base
{
    /**
     * Entity manager
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * Validator
     * @var Validator
     */
    protected $validator;

    /**
     * @var boolean
     */
    protected $readonly;

    /**
     * Construtor
     * @param EntityManagerInterface $entityManager
     * @param \Symfony\Component\Validator\Validator\LegacyValidator|Validator $validator
     * @param boolean $readonly
     */
    public function __construct(EntityManagerInterface $entityManager, Validator $validator, $readonly)
    {
        $this->entityManager = $entityManager;
        $this->validator = $validator;
        $this->readonly = (boolean)$readonly;
    }
}
