<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database\ServiceProvider;

use Sso\WebserviceBundle\Entity\ServiceProvider\Type\Log as LogModel;

/**
 * Class Log
 * @package Sso\WebserviceBundle\Database\ServiceProvider
 */
class Log extends Base
{
    /**
     * List of all log entries
     * @return array
     */
    public function getAll()
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\ServiceProvider\Type\Log')->findBy(array(), array('Date' => 'desc'));
    }

    /**
     * Save log
     * @param \Sso\WebserviceBundle\Entity\ServiceProvider\Type\Log $model
     * @return boolean
     */
    public function saveLog(LogModel $model)
    {
        $model->initUsageId();

        if (!$this->readonly) {
            $this->entityManager->persist($model);
            $this->entityManager->flush($model);
        }
    }
}
