<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database\ServiceProvider;

/**
 * Class ServiceName
 * @package Sso\WebserviceBundle\Database\ServiceProvider
 */
class ServiceName extends Base
{
    /**
     * List of all service names
     * @return array
     */
    public function getAll()
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\ServiceProvider\Type\ServiceName')->findAll();
    }

    /**
     * List of all service names
     * @return array
     */
    public function getOne($serviceNameId)
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\ServiceProvider\Type\ServiceName')->findOneBy(['ServiceNameId'=>$serviceNameId]);
    }
}
