<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database\ServiceProvider;

use Sso\WebserviceBundle\Entity\ServiceProvider\Type\TokenUsage as ModelTokenUsage;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;
use Sso\WebserviceBundle\Entity\ServiceProvider\Type;

/**
 * Class TokenUsage
 * @package Sso\WebserviceBundle\Database\ServiceProvider
 */
class TokenUsage extends Base
{

    /**
     * Current item
     * @var Type\TokenUsage
     */
    protected $_usageModel;

    /**
     * List of all token usages
     * 
     * @return array
     */
    public function getAll()
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\ServiceProvider\Type\TokenUsage')->findBy(array(), array('Date' => 'desc'));
    }

    /**
     * Set remote ip
     * @param string $ipAddress
     */
    public function setIp($ipAddress)
    {
        $this->_getModel()->setIp($ipAddress);
        $this->_saveModel();
    }

    /**
     * Set controller name
     * @param string $controllerName
     */
    public function setController($controllerName)
    {
        $this->_getModel()->setController($controllerName);
        $this->_saveModel();
    }

    /**
     * Set action name
     * @param string $actionName
     */
    public function setAction($actionName)
    {
        $this->_getModel()->setAction($actionName);
        $this->_saveModel();
    }

    /**
     * Set service token
     * @param Type\Token $token
     */
    public function setToken($token)
    {
        $this->_getModel()->setToken($token);
        $this->_saveModel();
    }

    /**
     * Save current model
     */
    protected function _saveModel()
    {
        $model = $this->_getModel();
        if ($model->isValid()) {
            $this->saveTokenUsage($model);
        }
    }

    /**
     * Get token usage model
     * @return Type\TokenUsage
     */
    protected function _getModel()
    {
        if (null === $this->_usageModel) {
            $this->_usageModel = new ModelTokenUsage();
            $this->_usageModel->initUsageId();
            $this->_usageModel->setDate(new \DateTime());
            $this->_usageModel->setTrackId(ApiException::getTrackId());
        }
        return $this->_usageModel;
    }

    /**
     * Save token usage model
     * @param ModelTokenUsage $modelTokenUsage
     */
    public function saveTokenUsage(ModelTokenUsage $modelTokenUsage)
    {
        if (!$this->readonly) {
            $this->entityManager->persist($modelTokenUsage);
            $this->entityManager->flush($modelTokenUsage);
        }
    }

    /**
     * @return \Doctrine\ORM\EntityRepository
     */
    public function getRepository()
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\ServiceProvider\Type\TokenUsage');
    }
}
