<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database\Webservice;

use Sso\WebserviceBundle\Entity\Webservice\Type\PasswordHistory as Password;

/**
 * Class PasswordHistory
 * @package Sso\WebserviceBundle\Database\Webservice
 */
class PasswordHistory extends Base
{
    /**
     * @return Password
     */
    public function newPassword()
    {
        return new Password();
    }

    /**
     * @param $userGuid
     * @return array|Password[]
     */
    public function getPasswords($userGuid)
    {
        return $this->entityManager
            ->getRepository('Sso\WebserviceBundle\Entity\Webservice\Type\PasswordHistory')
            ->findBy(
                [
                    'userGuid' => $userGuid
                ],
                [
                    'addedAt' => 'DESC'
                ]
            );
    }

    /**
     * @param Password $password
     */
    public function savePassword(Password $password)
    {
        $this->entityManager->persist($password);
        $this->entityManager->flush();
    }

    /**
     * @param Password $password
     */
    public function deletePassword(Password $password)
    {
        $this->entityManager->remove($password);
        $this->entityManager->flush();
    }
}
