<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class PasswordCryptPass
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\DependencyInjection\Compiler
 */
class PasswordCryptPass implements CompilerPassInterface
{
    use PriorityTaggedServiceTrait;

    const SERVICE_ID = 'sso_webservice.password_crypt.password_crypt_repository';
    const TAG_NAME = 'sso_webservice.password_crypter';

    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        if (!$container->has(self::SERVICE_ID)) {
            return;
        }

        $definition = $container->findDefinition(self::SERVICE_ID);

        $taggedServices = $this->findAndSortTaggedServices(self::TAG_NAME, $container);
        foreach ($taggedServices as $taggedService) {
            $definition->addMethodCall('addPasswordCrypter', array($taggedService));
        }
    }
}
