<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * Class SsoWebserviceExtension
 * @package Sso\WebserviceBundle\DependencyInjection
 */
class SsoWebserviceExtension extends Extension
{
    /**
     * {@inheritDoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        if (!$container->has('webservice.password.policy.history.size')) {
            $container->setParameter('webservice.password.policy.history.size', $config['password_history_size']);
        }

        $this->configureFeatureToggle($container, isset($config['feature_toggle']) ? $config['feature_toggle'] : []);
        $this->configurePasswordCrypt($container, $config['password_encrypt_default_type']);
        $this->configureAccessConfiguration($container, $config['security']);
    }

    /**
     * @param ContainerBuilder $container
     * @param array $config
     */
    private function configureFeatureToggle(ContainerBuilder $container, array $config)
    {
        if (!$container->has('webservice.feature_toggle.feature_toggle') || 0 === count($config)) {
            return;
        }

        $enabledFeatures = [];
        foreach ($config as $feature => $properties) {
            if (in_array($properties['enabled'], ['true', true, '1', 1], true)) {
                $condition = null !== $properties['condition'] ? $properties['condition'] : true;
                $enabledFeatures[$feature] = $condition;
            }
        }

        $serviceDefinition = $container->getDefinition('webservice.feature_toggle.feature_toggle');
        $serviceDefinition->replaceArgument(0, $enabledFeatures);
    }

    /**
     * @param ContainerBuilder $container
     * @param string $passwordEncryptDefaultType
     */
    private function configurePasswordCrypt(ContainerBuilder $container, string $passwordEncryptDefaultType)
    {
        if (!$container->has('sso_webservice.password_crypt.password_crypt_repository')) {
            return;
        }

        $serviceDefinition = $container->getDefinition('sso_webservice.password_crypt.password_crypt_repository');
        $serviceDefinition->replaceArgument(0, $passwordEncryptDefaultType);
    }

    /**
     * @param ContainerBuilder $container
     * @param array $config
     */
    private function configureAccessConfiguration(ContainerBuilder $container, array $config)
    {
        if (!$container->has('sso_webservice.security_configuration.access_configuration')) {
            return;
        }

        $serviceDefinition = $container->getDefinition('sso_webservice.security_configuration.access_configuration');
        $serviceDefinition->setArguments([
            $config['user_access_application'],
        ]);
    }
}
