<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Entity\ServiceProvider\Type;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class ServiceName
 * @package Sso\WebserviceBundle\Entity\ServiceProvider\Type
 */
class ServiceName
{

    /**
     * @var integer
     */
    private $ServiceNameId;

    /**
     * @var string
     */
    private $ServiceName;

    /**
     * @var integer
     */
    private $ServiceActive;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $Services;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $Tokens;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->Services = new \Doctrine\Common\Collections\ArrayCollection();
        $this->Tokens = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get ServiceNameId
     *
     * @return integer 
     */
    public function getServiceNameId()
    {
        return $this->ServiceNameId;
    }

    /**
     * Set ServiceName
     *
     * @param string $serviceName
     * @return ServiceName
     */
    public function setServiceName($serviceName)
    {
        $this->ServiceName = $serviceName;

        return $this;
    }

    /**
     * Get ServiceName
     *
     * @return string 
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }

    /**
     * Set ServiceActive
     *
     * @param integer $serviceActive
     * @return ServiceName
     */
    public function setServiceActive($serviceActive)
    {
        $this->ServiceActive = $serviceActive;

        return $this;
    }

    /**
     * Get ServiceActive
     *
     * @return integer 
     */
    public function getServiceActive()
    {
        return $this->ServiceActive;
    }

    /**
     * Add Services
     *
     * @param \Sso\WebserviceBundle\Entity\ServiceProvider\Type\Service $services
     * @return ServiceName
     */
    public function addService(\Sso\WebserviceBundle\Entity\ServiceProvider\Type\Service $services)
    {
        $this->Services[] = $services;

        return $this;
    }

    /**
     * Remove Services
     *
     * @param \Sso\WebserviceBundle\Entity\ServiceProvider\Type\Service $services
     */
    public function removeService(\Sso\WebserviceBundle\Entity\ServiceProvider\Type\Service $services)
    {
        $this->Services->removeElement($services);
    }

    /**
     * Get Services
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getServices()
    {
        return $this->Services;
    }

    /**
     * Add Tokens
     *
     * @param \Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token $tokens
     * @return ServiceName
     */
    public function addToken(\Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token $tokens)
    {
        $this->Tokens[] = $tokens;

        return $this;
    }

    /**
     * Remove Tokens
     *
     * @param \Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token $tokens
     */
    public function removeToken(\Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token $tokens)
    {
        $this->Tokens->removeElement($tokens);
    }

    /**
     * Get Tokens
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokens()
    {
        return $this->Tokens;
    }
}
