<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Entity\Webservice;

use Sso\WebserviceBundle\Api\Error\Type\Base as BaseError;
use Sso\WebserviceBundle\Api\Error\Storage as ErrorStorage;
use Sso\WebserviceBundle\Entity\Webservice\Exception;

/**
 * Class Base
 * @package Sso\WebserviceBundle\Entity\Webservice
 */
class Base
{

    /**
     * Errors
     * 
     * @var ErrorStorage
     */
    private $_errors;

    /**
     * Constructor
     */
    public function __construct()
    {
    }

    /**
     * Return with error
     * 
     * @param BaseError $error
     * @throws Exception
     */
    protected function _exception(BaseError $error = null)
    {
        if (null !== $error) {
            $this->errors()->addError($error);
        }
        $exception = new Exception();
        $exception->setErrors($this->errors()->getErrors());
        throw $exception;
    }

    /**
     * Get error storage
     * 
     * @return ErrorStorage
     */
    public function errors()
    {
        return $this->_errors ? $this->_errors : ($this->_errors = new ErrorStorage());
    }
}
