<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Entity\Webservice\Type;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class PasswordPolicy
 * @package Sso\WebserviceBundle\Entity\Webservice\Type
 */
class PasswordPolicy
{
    /**
     * @var string
     */
    private $policyId;

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $regEx;

    /**
     * @var array
     */
    private $regexErrorMessages = [];

    /**
     * @var integer
     */
    private $validityDuration;

    /**
     * @var array
     */
    private $validityDurationErrorMessages = [];

    /**
     * @var integer
     */
    private $historySize;

    /**
     * @var array
     */
    private $historySizeErrorMessages = [];

    /**
     * @var integer
     */
    private $editDistance;

    /**
     * @var array
     */
    private $editDistanceErrorMessages = [];

    /**
     * @var integer
     */
    private $changeDelay;

    /**
     * @var array
     */
    private $changeDelayErrorMessages = [];

    /**
     * @var string
     */
    private $policyDescription;

    /**
     * @var bool
     */
    private $isDefault;

    /**
     * @var array
     */
    private $errorMessages = [];

    /**
     * @var PasswordPolicyValidations[]|ArrayCollection
     */
    private $passwordPolicyValidations;

    /**
     * PasswordPolicy constructor.
     */
    public function __construct()
    {
        $this->passwordPolicyValidations = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }

    /**
     * For unit testing only! Value will be generated on persist by UUID generator.
     *
     * @param string $policyId
     * @return PasswordPolicy
     */
    public function setPolicyId($policyId)
    {
        $this->policyId = $policyId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return PasswordPolicy
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string
     */
    public function getRegEx()
    {
        return $this->regEx;
    }

    /**
     * @param string $regEx
     * @return PasswordPolicy
     */
    public function setRegEx($regEx)
    {
        $this->regEx = $regEx;
        return $this;
    }

    /**
     * @return array
     */
    public function getRegexErrorMessages()
    {
        return $this->regexErrorMessages;
    }

    /**
     * @param array $regexErrorMessages
     * @return PasswordPolicy
     */
    public function setRegexErrorMessages($regexErrorMessages)
    {
        $this->regexErrorMessages = $regexErrorMessages;
        return $this;
    }

    /**
     * @return int
     */
    public function getValidityDuration()
    {
        return $this->validityDuration;
    }

    /**
     * @param int $validityDuration
     * @return PasswordPolicy
     */
    public function setValidityDuration($validityDuration)
    {
        $this->validityDuration = $validityDuration;
        return $this;
    }

    /**
     * @return array
     */
    public function getValidityDurationErrorMessages()
    {
        return $this->validityDurationErrorMessages;
    }

    /**
     * @param array $validityDurationErrorMessages
     * @return PasswordPolicy
     */
    public function setValidityDurationErrorMessages($validityDurationErrorMessages)
    {
        $this->validityDurationErrorMessages = $validityDurationErrorMessages;
        return $this;
    }

    /**
     * @return int
     */
    public function getHistorySize()
    {
        return $this->historySize;
    }

    /**
     * @param int $historySize
     * @return PasswordPolicy
     */
    public function setHistorySize($historySize)
    {
        $this->historySize = $historySize;
        return $this;
    }

    /**
     * @return array
     */
    public function getHistorySizeErrorMessages()
    {
        return $this->historySizeErrorMessages;
    }

    /**
     * @param array $historySizeErrorMessages
     * @return PasswordPolicy
     */
    public function setHistorySizeErrorMessages($historySizeErrorMessages)
    {
        $this->historySizeErrorMessages = $historySizeErrorMessages;
        return $this;
    }

    /**
     * @return int
     */
    public function getEditDistance()
    {
        return $this->editDistance;
    }

    /**
     * @param int $editDistance
     * @return PasswordPolicy
     */
    public function setEditDistance($editDistance)
    {
        $this->editDistance = $editDistance;
        return $this;
    }

    /**
     * @return array
     */
    public function getEditDistanceErrorMessages()
    {
        return $this->editDistanceErrorMessages;
    }

    /**
     * @param array $editDistanceErrorMessages
     * @return PasswordPolicy
     */
    public function setEditDistanceErrorMessages($editDistanceErrorMessages)
    {
        $this->editDistanceErrorMessages = $editDistanceErrorMessages;
        return $this;
    }

    /**
     * @return int
     */
    public function getChangeDelay()
    {
        return $this->changeDelay;
    }

    /**
     * @param int $changeDelay
     * @return PasswordPolicy
     */
    public function setChangeDelay($changeDelay)
    {
        $this->changeDelay = $changeDelay;
        return $this;
    }

    /**
     * @return array
     */
    public function getChangeDelayErrorMessages()
    {
        return $this->changeDelayErrorMessages;
    }

    /**
     * @param array $changeDelayErrorMessages
     * @return PasswordPolicy
     */
    public function setChangeDelayErrorMessages($changeDelayErrorMessages)
    {
        $this->changeDelayErrorMessages = $changeDelayErrorMessages;
        return $this;
    }

    /**
     * @return string
     */
    public function getPolicyDescription()
    {
        return $this->policyDescription;
    }

    /**
     * @param string $policyDescription
     * @return PasswordPolicy
     */
    public function setPolicyDescription($policyDescription)
    {
        $this->policyDescription = $policyDescription;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDefault()
    {
        return $this->isDefault;
    }

    /**
     * @param bool $isDefault
     * @return PasswordPolicy
     */
    public function setDefault($isDefault)
    {
        $this->isDefault = $isDefault;
        return $this;
    }

    /**
     * @return array
     */
    public function getErrorMessages()
    {
        return $this->errorMessages;
    }

    /**
     * @param array $errorMessages
     * @return PasswordPolicy
     */
    public function setErrorMessages($errorMessages)
    {
        $this->errorMessages = $errorMessages;
        return $this;
    }

    /**
     * @param PasswordPolicyValidations $passwordPolicyValidation
     * @return PasswordPolicy
     */
    public function addPasswordPolicyValidation(PasswordPolicyValidations $passwordPolicyValidation)
    {
        if (!$this->passwordPolicyValidations->contains($passwordPolicyValidation)) {
            $passwordPolicyValidation->setPasswordPolicy($this);
            $this->passwordPolicyValidations->add($passwordPolicyValidation);
        }

        return $this;
    }

    /**
     * @param PasswordPolicyValidations
     * @return PasswordPolicy
     */
    public function removePasswordPolicyValidation(PasswordPolicyValidations $passwordPolicyValidation)
    {
        if ($this->passwordPolicyValidations->contains($passwordPolicyValidation)) {
            $passwordPolicyValidation->removePasswordPolicy();
            $this->passwordPolicyValidations->remove($passwordPolicyValidation);
        }

        return $this;
    }

    /**
     * @return PasswordPolicyValidations[]|ArrayCollection
     */
    public function getPasswordPolicyValidations()
    {
        return $this->passwordPolicyValidations;
    }

    /**
     * @param PasswordPolicyValidations[]|ArrayCollection $passwordPolicyValidations
     */
    public function setPasswordPolicyValidations($passwordPolicyValidations)
    {
        $this->passwordPolicyValidations =new ArrayCollection();
        foreach ($passwordPolicyValidations as $validation) {
            $this->addPasswordPolicyValidation($validation);
        }
    }
}
