<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler;

use Sso\WebserviceBundle\Services\ApiVersionInflector;
use JMS\Serializer\SerializerInterface;
use Sso\WebserviceBundle\EventListener\PerformanceListener;
use Symfony\Component\HttpKernel\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Response as SymfonyResponse;

/**
 * Class Manager
 * @package Sso\WebserviceBundle\ErrorHandler
 */
final class Manager
{

    /**
     * @var array
     */
    private $setter;


    /**
     * @var ApiVersionInflector
     */
    private $apiVersionInflector;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var PerformanceListener
     */
    private $performanceListener;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * Manager constructor.
     * @param ApiVersionInflector $apiVersionInflector
     * @param SerializerInterface $serializer
     */
    public function __construct(ApiVersionInflector $apiVersionInflector, SerializerInterface $serializer, PerformanceListener $performanceListener, LoggerInterface $logger)
    {
        $this->apiVersionInflector = $apiVersionInflector;
        $this->serializer = $serializer;
        $this->performanceListener = $performanceListener;
        $this->logger = $logger;
    }

    /**
     * @return ErrorStorage\Factory
     */
    public function errorStorage(){
        //we always need the same instance here!
        return isset($this->setter[__METHOD__]) ? $this->setter[__METHOD__] : ($this->setter[__METHOD__] = new ErrorStorage\Factory($this->logger));
    }

    /**
     * @return Response\Factory
     */
    public function response(){
        return isset($this->setter[__METHOD__]) ? $this->setter[__METHOD__] : ($this->setter[__METHOD__] = new Response\Factory($this));
    }

    /**
     * @return \Sso\WebserviceBundle\Services\ApiVersionInflector
     */
    public function getApiVersionInflector(){
        return $this->apiVersionInflector;
    }

    /**
     * @return SerializerInterface
     */
    public function getSerializer(){
        return $this->serializer;
    }

    /**
     * @return float
     */
    public function getScriptSeconds(){
        return $this->performanceListener->getScriptSeconds();
    }

    /**
     * @return SymfonyResponse
     */
    public function getSymfonyResponse(){
        return new SymfonyResponse();
    }

    /**
     * @return LoggerInterface
     */
    public function logger(){
        return $this->logger;
    }
    
    /**
     * @param mixed $class
     * @return string
     */
    public function getClassNameFromObject($class)
    {
        try {
            $classname = get_class($class);
        } catch (\Exception $exc) {
            return $class;
        }
        if ($pos = strrpos($classname, '\\')) {
            $class = substr($classname, $pos + 1);
        }
        return $class;
    }
}
