<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response;


/**
 * Interface FactoryInterface
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response
 */
interface ErrorsInterface
{
    /**
     * ErrorsInterface constructor.
     */
    public function __construct();

    /**
     * @return integer
     */
    public function getCode();

    /**
     * @return string
     */
    public function getStatus();

    /**
     * @return string
     */
    public function getController();

    /**
     * @return string
     */
    public function getAction();

    /**
     * @return ErrorsInterface
     */
    public function getErrors();

    /**
     * @param ErrorInterface $error
     * @return $this
     */
    public function addError(ErrorInterface $error);
}
