<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response;

use Sso\WebserviceBundle\ErrorHandler\Manager as ErrorManager;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response
 */
final class Factory
{
    /**
     * @var ErrorManager
     */
    private $errorManager;

    /**
     * @var \Sso\WebserviceBundle\Services\ApiVersionInflector
     */
    private $apiVersionInflector;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * Factory constructor.
     * @param ErrorManager $errorManager
     */
    public function __construct(ErrorManager $errorManager)
    {
        $this->errorManager= $errorManager;
        $this->apiVersionInflector = $errorManager->getApiVersionInflector();
    }

    /**
     * @return FactoryInterface
     */
    public function response()
    {
        $className = $this->apiVersionInflector->inflect(__NAMESPACE__, 'Factory');
        return isset($this->factory[__METHOD__]) ? $this->factory[__METHOD__] : ($this->factory[__METHOD__] = new $className($this->errorManager));
    }
}
