<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version1;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorInterface;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\XmlRoot("Error")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version1
 */
class Error implements ErrorInterface
{

    /**
     * @Serializer\SerializedName("ErrorCode")
     * @Serializer\Type("string")
     * @var string
     */
    private $errorCode;

    /**
     * @Serializer\SerializedName("ErrorRef")
     * @Serializer\Type("string")
     * @var string
     */
    private $errorRef;

    /**
     * @Serializer\SerializedName("ShortMessage")
     * @Serializer\Type("string")
     * @var string
     */
    private $shortMessage;

    /**
     * @Serializer\SerializedName("LongMessage")
     * @Serializer\Type("string")
     * @var string
     */
    private $longMessage;

    /**
     *
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     *
     * @return string
     */
    public function getErrorRef()
    {
        return $this->errorRef;
    }

    /**
     *
     * @return string
     */
    public function getShortMessage()
    {
        return $this->shortMessage;
    }

    /**
     *
     * @return string
     */
    public function getLongMessage()
    {
        return $this->longMessage;
    }

    /**
     *
     * @param string $errorCode
     */
    public function setErrorCode($errorCode)
    {
        $this->errorCode = $errorCode;
    }

    /**
     *
     * @param string $errorRef
     */
    public function setErrorRef($errorRef)
    {
        $this->errorRef = $errorRef;
    }

    /**
     *
     * @param string $shortMessage
     */
    public function setShortMessage($shortMessage)
    {
        $this->shortMessage = $shortMessage;
    }

    /**
     *
     * @param string $longMessage
     */
    public function setLongMessage($longMessage)
    {
        $this->longMessage = $longMessage;
    }
}