<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version1;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsBuilderInterface;
use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use Sso\WebserviceBundle\ErrorHandler\Manager as ErrorManager;
use Sso\WebserviceBundle\ErrorHandler\ErrorStorage\Error as ErrorStorageError;

/**
 * Class ErrorsBuilder
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version1
 */
final class ErrorsBuilder implements ErrorsBuilderInterface
{

    /**
     * @var \Sso\WebserviceBundle\ErrorHandler\ErrorStorage\Errors
     */
    private $errorsStorage;

    /**
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * @var ErrorManager
     */
    private $errorManager;

    /**
     * @var array
     */
    private $errorMapping = [
        'getErrorCode' => 'setErrorCode',
        'getErrorRef' => 'setErrorRef',
        'getShortMessage' => 'setShortMessage',
        'getLongMessage' => 'setLongMessage'
    ];

    /**
     * ErrorsBuilder constructor.
     * @param ErrorManager $errorManager
     */
    public function __construct(ErrorManager $errorManager)
    {
        $this->errorManager = $errorManager;
        $this->errorsStorage = $errorManager->errorStorage()->getStoredErrors();
        $this->errors = new Errors();
    }

    /**
     * @return ErrorsInterface
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @return ErrorsInterface
     */
    public function buildErrors()
    {
        $this->errors->setAction($this->errorsStorage->getAction());
        $this->errors->setController($this->errorsStorage->getController());

        $httpStatusCode = max([ $this->errors->getStatus(), 200 ]);
        foreach ($this->errorsStorage->getErrors() as $error) {
            $httpStatusCode = max([$httpStatusCode, $error->getCode()]);
            $errorMapped = $this->mapErrorType($error);
            $this->errors->addError($errorMapped);
        }

        // Version 1 does not support any other http status code than 200 or 500
        $this->errors->setCode(200 < $httpStatusCode ? $httpStatusCode : 200);
        return $this->getErrors();
    }

    /**
     * @param ErrorStorageError $error
     * @return Error
     */
    private function mapErrorType(ErrorStorageError $error)
    {
        $errorObject = new Error();
        foreach ($this->errorMapping as $getter => $setter) {
            $errorObject->$setter($error->$getter());
        }
        return $errorObject;
    }
}
