<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response;

use Sso\WebserviceBundle\ErrorHandler\Response\ResponseInterface;
use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;

/**
 * Class Error
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response
 */
class Response implements ResponseInterface
{
    const STATUS_FAILURE = 'Failure';

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime<'c'>")
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\Type("array<Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response\UnknownController>")
     * @Serializer\XmlList(inline=true)
     * @Serializer\XmlKeyValuePairs()
     * @var UnknownController[]
     */
    private $controllers = [];

    /**
     * Error constructor.
     */
    public function __construct()
    {
        $this->trackId = ApiException::getTrackId();
        $this->date = new \DateTime();
        $this->status = static::STATUS_FAILURE;
    }

    /**
     * @param UnknownController $unknownController
     * @return $this
     */
    public function addUnknownController(UnknownController $unknownController){
        $this->controllers[$unknownController->getName()] = $unknownController;
        return $this;
    }
}
