<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use Sso\WebserviceBundle\ErrorHandler\Response\ResponseBuilderInterface;
use Sso\WebserviceBundle\ErrorHandler\Response\ResponseInterface;
use Sso\WebserviceBundle\ErrorHandler\Manager as ErrorManager;

/**
 * Class Error
 *
 * @Serializer\XmlRoot("Error")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response
 */
class ResponseBuilder implements ResponseBuilderInterface
{
    /**
     * @var ErrorManager
     */
    private $errorManager;

    /**
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * ResponseBuilder constructor.
     * @param ErrorsInterface $errors
     * @param ErrorManager $errorManager
     */
    public function __construct(ErrorsInterface $errors, ErrorManager $errorManager)
    {
        $this->errors = $errors;
        $this->errorManager = $errorManager;
    }

    /**
     * @return ResponseInterface
     */
    public function buildErrorResponse()
    {
        $unknownAction = new UnknownAction($this->errors->getAction());
        $unknownAction->setErrors($this->errors);

        $unknownController = new UnknownController($this->errors->getController());
        $unknownController->addUnknownAction($unknownAction);

        $response = new Response();
        $response->addUnknownController($unknownController);
        return $response;
    }
}
