<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UnknownAction
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response
 */
class UnknownAction
{

    const STATUS_FAILURE = 'Failure';

    /**
     * @Serializer\Exclude()
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\XmlList(inline = true)
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * UnknownAction constructor.
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
        $this->status = static::STATUS_FAILURE;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param ErrorsInterface $errors
     * @return UnknownAction
     */
    public function setErrors(ErrorsInterface $errors)
    {
        $this->errors = $errors;

        return $this;
    }
}
