<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version2\Response;

use Sso\WebserviceBundle\ErrorHandler\Response\ResponseInterface;
use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;
use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version2\Response
 */
class Response implements ResponseInterface
{
    /**
     * Serializer Mapping
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("TrackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("Controller")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $controller;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("Action")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $action;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     *
     * @var string
     */
    private $date;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("ScriptTimeSec")
     * @Serializer\Type("float")
     *
     * @var float
     */
    private $scriptTimeSec;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("ErrorCount")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $errorCount;

    /**
     * @Serializer\XmlList(inline = true)
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * Error constructor.
     */
    public function __construct()
    {
        $this->trackId = ApiException::getTrackId();
        $this->date = new \DateTime();
    }

    /**
     * @param ErrorsInterface $errors
     * @return UnknownAction
     */
    public function setErrors(ErrorsInterface $errors)
    {
        $this->errors = $errors;

        return $this;
    }

    /**
     * @param int $code
     * @return Response
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @param float $scriptTimeSec
     * @return Response
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;

        return $this;
    }

    /**
     * @param int $errorCount
     * @return Response
     */
    public function setErrorCount($errorCount)
    {
        $this->errorCount = $errorCount;

        return $this;
    }

    /**
     * @return string
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * @param string $controller
     * @return Response
     */
    public function setController($controller)
    {
        $this->controller = $controller;

        return $this;
    }

    /**
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * @param string $action
     * @return Response
     */
    public function setAction($action)
    {
        $this->action = $action;

        return $this;
    }
}